#ifndef CE2_HMAC_H
#define CE2_HMAC_H

/*
 * All the includes that are needed for code using this module to
 * compile correctly should be #included here.
 */
#include "CE2_public.h"

#ifdef __cplusplus
extern "C"
{
#endif

  /*
   *  Object %CE2_MAC.h    : %
   *  State           :  %state%
   *  Creation date   :  Sun Nov 28 20:51:23 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief This file contains all of the enums and definitions that are used for the 
   *         CE2 HMAC APIs, as well as the APIs themselves
   *
   *  \version CE2_HASH.h#1:incl:13
   *  \author adams
   *  \remarks Copyright (C) 2005 by Discretix Technologies Ltd.
   *           All Rights reserved
   */
 
/************************ Defines ******************************/

/* The HMAC key size after padding for MD5, SHA1, SHA256 */
#define CE2_HMAC_KEY_SIZE_IN_BYTES 64

/* The HMAC key size after padding for SHA384, SHA512 */
#define CE2_HMAC_SHA2_1024BIT_KEY_SIZE_IN_BYTES 128

/************************ Enums ********************************/

/************************ Typedefs  ****************************/

/* ********************** Structures *************************** */

/************************ Structs  ******************************/


/************************ Public Variables **********************/


/************************ Public Functions **********************/

/**
****************************************************************
* Function Name: 
*  CE2_HMAC
*
* Inputs:
* @param OperationMode [in] - The operation mode:
*                  SHA1, SHA224, SHA256, SHA384, SHA512, MD5;
* @param key_ptr [in] - The pointer to the user's key buffer;
* @param keySize [in] - The size of the received key;
* @param DataIn_ptr [in] - A pointer to the buffer that stores the data to be hashed;
* @param DataSize [in] - The size of the data to be hashed, in bytes;
* @param HmacResultBuff [out] - A pointer to the target buffer where the 
*                   HMAC result stored in the context is loaded to;
*
* Outputs: @returns \b
*  CE2Error_t  
*  - CE2_OK - On success
*  - Otherwise - error code:
*   - CE2_HMAC_ILLEGAL_HASH_OP_MODE_ERROR
*   - CE2_HMAC_INVALID_KEY_PTR_ERROR
*   - CE2_HMAC_INVALID_DATA_IN_PTR_ERROR
*   - CE2_HMAC_INVALID_HASH_RESULT_BUFF_PTR_ERROR
*
* \brief \b
* Description:
*   The function allocates an internal HASH Context, it initializes the 
* HASH Context with the cryptographic attributes that are needed for 
* the HASH block operation (initializes H's value for the HASH algorithm).
* Next the function loads the engine with the initializing values, 
* and then processes the data block, calculating the hash.
* Finally, the function return the message digest of the data buffer .
*
* \b
* Algorithm:
*  -# Verify input parameters for validity;
*  -# Call low level function LLF_HMAC
*    to calculate HASH of inputted data with using LibTomCrypt.
***************************************************************/
CE2CIMPORT_C CE2Error_t CE2_HMAC  ( CE2_HASH_OperationMode_t  OperationMode,
                         DxUint8_t                    *key_ptr,
                         DxUint16_t                    keySize,
                         DxUint8_t                    *DataIn_ptr,
                         DxUint32_t                    DataSize,
                         CE2_HASH_Result_t          HmacResultBuff );
#ifdef __cplusplus
}
#endif

#endif
